# Ćwiczenie 2

## Zadanie
Utwórz dwie funkcje. Funkcja `UpdateSlice` pobiera wartości typu `[]string` i `string`. Ostatnią pozycję w przekazanym wycinku definiuje jako przekazana wartość typu `string`. Na koniec funkcja `UpdateSlice` wyświetla wycinek po przeprowadzonej zmianie. Funkcja `GrowSlice` również pobiera dane typu `[]string` i `string`. Wartość typu `string` dołącza do wycinka. Na koniec funkcja `GrowSlice` wyświetla wycinek po przeprowadzonej zmianie. Obie funkcje wywołaj z poziomu funkcji `main`. Wycinek powinien być wyświetlony zarówno przed wywołaniem funkcji jak i po wywołaniu poszczególnych funkcji. Czy wiesz, dlaczego niektóre zmiany są widoczne z poziomu funkcji `main`, zaś inne nie?

## Rozwiązanie

Logika polegająca na uaktualnieniu ostatniego elementu wycinka nową wartością nie jest trudna do zaimplementowania. Jednak w przeciwieństwie do Pythona, w Go nie ma takiego skrótu.

```go
func UpdateSlice(s []string, val string) {
	s[len(s)-1] = val
	fmt.Println("in UpdateSlice:", s)
}

func GrowSlice(s []string, val string) {
	s = append(s, val)
	fmt.Println("in GrowSlice:", s)
}

func main() {
	s := []string{"a", "b", "c"}
	UpdateSlice(s, "d")
	fmt.Println("in main after UpdateSlice:", s)
	GrowSlice(s, "e")
	fmt.Println("in main, after GrowSlice:", s)
}
```

Wykonanie tego kodu powoduje wygenerowanie następujących danych wyjściowych:

```shell
$ go build
$ ./ex2 
in UpdateSlice: [a b d]
in main after UpdateSlice: [a b d]
in GrowSlice: [a b d e]
in main, after GrowSlice: [a b d]
```

Możesz zobaczyć, że zmiana zawartości wycinka jest widoczna po jego przekazaniu funkcji, natomiast zmiany wykraczające poza długość wycinka już nie są przekazywane.